/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.autoeffect;

import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.Envelope;

public class VolumeEnvelope
implements Envelope {
    private int sustainPoint;
    private int loopStart;
    private int loopEnd;
    private int type;
    public static final int ON = 1;
    public static final int SUSTAIN = 2;
    public static final int LOOP = 4;
    private boolean on;
    private boolean[] keyOff;
    private double[] volumeCurve;
    private int[] tOffset;

    public VolumeEnvelope(int[] offset, double[] volume, int numberOfPoints, int sustainPoint, int loopStart, int loopEnd, int type) {
        if (loopEnd - loopStart <= 0 && (type & 4) != 0) {
            type -= 4;
        }
        this.type = type;
        this.on = true;
        if ((type & 1) == 0 || numberOfPoints == 0) {
            this.volumeCurve = new double[]{1.0};
            this.on = false;
        } else if (numberOfPoints > 1) {
            this.volumeCurve = new double[offset[numberOfPoints - 1]];
            int n = 0;
            while (n < numberOfPoints - 1) {
                int m = offset[n];
                while (m < offset[n + 1]) {
                    this.volumeCurve[m] = volume[n] + (volume[n + 1] - volume[n]) * (double)(m - offset[n]) / (double)(offset[n + 1] - offset[n]);
                    ++m;
                }
                ++n;
            }
        } else {
            this.volumeCurve = new double[]{volume[0]};
        }
        if ((type & 2) != 0) {
            this.sustainPoint = offset[sustainPoint];
        }
        if ((type & 4) != 0) {
            this.loopStart = offset[loopStart];
            if (this.loopStart < 0) {
                this.loopStart = 0;
            }
            this.loopEnd = offset[loopEnd];
            if (this.loopEnd >= this.volumeCurve.length) {
                this.loopEnd = this.volumeCurve.length - 1;
            }
        }
    }

    public void setNumberOfTracks(int tracks) {
        this.tOffset = new int[tracks];
        this.keyOff = new boolean[tracks];
    }

    public void keyOff(int track) {
        this.keyOff[track] = true;
    }

    public void newNote(double note, int track) {
        if (note != -2.0) {
            this.tOffset[track] = 0;
            this.keyOff[track] = false;
        }
    }

    public void doEffect(TrackState state, int track) {
        int ofs = this.tOffset[track];
        if (!this.on) {
            state.setEnvelopeVolume(this.volumeCurve[0]);
            return;
        }
        if ((this.type & 4) != 0) {
            if (ofs < this.loopEnd) {
                state.setEnvelopeVolume(this.volumeCurve[ofs]);
            } else {
                int rofs = (ofs - this.loopStart) % (this.loopEnd - this.loopStart) + this.loopStart;
                state.setEnvelopeVolume(this.volumeCurve[rofs]);
            }
        } else if (ofs >= this.volumeCurve.length) {
            state.setEnvelopeVolume(this.volumeCurve[this.volumeCurve.length - 1]);
        } else {
            state.setEnvelopeVolume(this.volumeCurve[ofs]);
        }
        if ((this.type & 2) == 0 || ofs != this.sustainPoint || this.keyOff[track]) {
            int n = track;
            this.tOffset[n] = this.tOffset[n] + 1;
        }
    }

    public boolean isActive() {
        return this.on;
    }

    public void reset(int track) {
        this.keyOff[track] = false;
        this.tOffset[track] = 0;
    }

    public void setPosition(int pos, int track) {
        this.tOffset[track] = pos < this.volumeCurve.length ? pos : this.volumeCurve.length - 1;
    }
}

